/*****
 *       Mean value calculation example
 *                                                                   
 *  Copyright (C) 2015 Henrik Sandklef 
 *                                                                   
 * This program is free software; you can redistribute it and/or     
 * modify it under the terms of the GNU General Public License       
 * as published by the Free Software Foundation; either version 3    
 * of the License, or any later version.                             
 *                                                                   
 *                                                                   
 * This program is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
 * GNU General Public License for more details.                      
 *                                                                   
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software       
 * Foundation, Inc., 51 Franklin Street, Boston,            
 * MA  02110-1301, USA.                                              
 ****/

/**
 * @file parser.h
 * @author Henrik Sandklef
 * @date 25 Nov 2015
 * @brief Functions to parse arguments from user
 *
 */

/**
 * @brief Given an 'array' of int in string format, this function
 * returns a list of intgers.
 *
 * \warning { This function allocates dynamically. Make sure you free
 * the memory }

 *
 * @param int size - number of arguments in 
 * @param int int_strings - integers in string format
 * 
 * @return @c Pointer to int (an 'array')
 */
int * strings_to_ints(int size, char **int_strings);

/**
 * @brief Frees the memory allocated by strings_to_ints
 *
 * @param int *p - memory to free
 * 
 */
void free_ints(int  *p);

/**
 * @brief Frees the memory allocated by strings_to_ints and sets the pointer to NULL
 *
 * @param int *p - memory to free
 * 
 */
#define FREE_INTS(p) free_ints(p); p=NULL;
